/*
 * Decompiled with CFR 0.152.
 */
package skeletonapplet;

import java.applet.Applet;
import java.util.List;
import netscape.javascript.JSObject;
import skeletonapplet.AbstractDelegatorApplet;
import skeletonapplet.JreDatum;
import skeletonapplet.JreInfo;
import skeletonapplet.PtsiAppletWorker;
import skeletonapplet.SynchronizedQueue;
import skeletonapplet.Utilities;

public class PtsiApplet
extends AbstractDelegatorApplet {
    protected PtsiAppletWorker myWorker;
    protected String checkString = null;
    protected SynchronizedQueue queue = new SynchronizedQueue();
    protected Thread runThread = new Thread(){

        public void run() {
            PtsiApplet.this.doWork();
        }
    };
    protected boolean shouldStop = false;
    protected String status = "empty";
    protected boolean workerPrepared = false;

    public PtsiApplet() {
        this.runThread.start();
    }

    public void destroy() {
        this.stopRunning();
        if (this.myWorker != null) {
            try {
                this.myWorker.destroy();
                this.myWorker = null;
                this.workerPrepared = false;
            }
            catch (Throwable throwable) {
                Utilities.checkSwallow(throwable);
            }
        }
        super.destroy();
    }

    public String getStatus() {
        return this.status;
    }

    public void goToErrorPage(String string, String string2) {
        this.callJavascript("error", string, string2);
    }

    public String initialize() {
        this.queue.add("initialize");
        return "initialization underway";
    }

    public void loadingStatus(int n, int n2) {
        this.loadingStatus(n, n2, 0);
    }

    public void loadingStatus(int n, int n2, int n3) {
        this.ptLoadingStatus(n, n2, n3);
    }

    public void loadPTItem(String string) {
        this.queue.add("loadPTItem:" + string);
    }

    public void setStatus(String string) {
        this.status = string;
        this.ptSetStatus(string);
    }

    public void start() {
        this.setStatus("empty");
        super.startSimple();
    }

    public String startSystemCheck() {
        this.queue.add("startSystemCheck");
        return null;
    }

    public void stop() {
        this.setStatus("empty");
        this.stopRunning();
        if (this.myWorker != null) {
            try {
                this.myWorker.stop();
                this.workerPrepared = false;
            }
            catch (Throwable throwable) {
                Utilities.checkSwallow(throwable);
            }
        }
        super.stop();
    }

    public void throwError(String string) {
        this.setStatus("error");
        this.ptThrowError(string);
    }

    public void unloadPTItem() {
        this.queue.add("unloadPTItem");
    }

    public void updateRender() {
        this.ptUpdateRender();
    }

    protected void addInformation(StringBuilder stringBuilder, JreDatum jreDatum) {
        stringBuilder.append(jreDatum.getPrettyName() + ":\n");
        stringBuilder.append("\t" + (jreDatum.isUnavailable() ? "Not Available" : jreDatum.getDynamicValue()));
        stringBuilder.append("\n");
    }

    protected void addInformation(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(string + ":\n");
        stringBuilder.append("\t" + string2);
        stringBuilder.append("\n");
    }

    protected void addInformation(StringBuilder stringBuilder, String string, Throwable throwable) {
        stringBuilder.append(string + ":\n");
        stringBuilder.append("\t" + throwable);
        stringBuilder.append("\n");
    }

    protected Object callJavascript(String string) {
        String[] stringArray = new String[]{};
        return this.callJavascript(string, stringArray);
    }

    protected Object callJavascript(String string, int n) {
        String[] stringArray = new String[]{String.valueOf(n)};
        return this.callJavascript(string, stringArray);
    }

    protected Object callJavascript(String string, int n, int n2, int n3) {
        String[] stringArray = new String[]{String.valueOf(n), String.valueOf(n2), String.valueOf(n3)};
        return this.callJavascript(string, stringArray);
    }

    protected Object callJavascript(String string, int n, String string2, String string3) {
        String[] stringArray = new String[]{String.valueOf(n), string2, string3};
        return this.callJavascript(string, stringArray);
    }

    protected Object callJavascript(String string, String string2) {
        String[] stringArray = new String[]{string2};
        return this.callJavascript(string, stringArray);
    }

    protected Object callJavascript(String string, String string2, String string3) {
        String[] stringArray = new String[]{string2, string3};
        return this.callJavascript(string, stringArray);
    }

    protected Object callJavascript(String string, String[] stringArray) {
        JSObject jSObject = JSObject.getWindow((Applet)this);
        return jSObject.call(string, stringArray);
    }

    protected void doInitialize() {
        this.prepareWorker(false);
    }

    protected void doSystemCheck() {
    }

    protected void doWork() {
        while (!this.shouldStop) {
            Object object = this.queue.next();
            if (object == null) continue;
            String string = (String)object;
            String string2 = null;
            int n = string.indexOf(":");
            if (n >= 0) {
                string2 = string.substring(n + 1).trim();
                string = string.substring(0, n);
            }
            if (string.equalsIgnoreCase("initialize")) {
                this.doInitialize();
                continue;
            }
            if (string.equalsIgnoreCase("loadPTItem")) {
                this.myWorker.loadPTItem(string2);
                continue;
            }
            if (string.equalsIgnoreCase("startSystemCheck")) {
                this.doSystemCheck();
                continue;
            }
            if (!string.equalsIgnoreCase("unloadPTItem")) continue;
            this.myWorker.unloadPTItem();
        }
    }

    protected void prepareWorker(boolean bl) {
        if (this.workerPrepared) {
            return;
        }
        this.workerPrepared = true;
        boolean bl2 = false;
        Throwable throwable = null;
        boolean bl3 = JreInfo.soleInstance().hasErrors();
        if (!bl3) {
            try {
                if (this.worker == null) {
                    this.internalInstantiateWorker();
                }
                this.myWorker = (PtsiAppletWorker)this.worker;
                if (this.worker != null) {
                    this.worker.start();
                    if (bl) {
                        this.myWorker.performSystemCheck();
                    }
                }
            }
            catch (Throwable throwable2) {
                Utilities.check(throwable2);
                bl2 = true;
                throwable = throwable2;
            }
        }
        if ((bl3 = JreInfo.soleInstance().hasErrors()) || bl2) {
            String string = this.getErrorId(throwable);
            this.checkString = this.getErrorText(this.jreInfo.getErrors());
            this.ptDebug("Initialization Error(s): " + this.checkString);
            this.throwError(string);
        } else {
            this.checkString = null;
            if (!this.status.equals("error")) {
                this.setStatus("ready");
            }
        }
    }

    protected String getErrorId(Throwable throwable) {
        String string = "Unknown error";
        String string2 = "XP-ERR-016";
        JreInfo jreInfo = JreInfo.soleInstance();
        if (throwable != null) {
            string = "Start error: " + throwable;
            string2 = "XP-ERR-020";
        } else if (jreInfo.browserName.isError()) {
            string = "Invalid browser: " + jreInfo.browserName.getDynamicValue();
            string2 = "XP-ERR-029";
        } else if (jreInfo.jreVersion.isError()) {
            string = "Invalid JRE version: " + jreInfo.jreVersion.getDynamicValue();
            string2 = "XP-ERR-003";
        } else if (jreInfo.ptDirectory.isError()) {
            string = "Unable to find PT directory";
            string2 = "XP-ERR-005";
        } else if (jreInfo.securityAccess.isError()) {
            string = "No security access";
            string2 = "XP-ERR-006";
        } else if (jreInfo.missingPtaJarFile.isError()) {
            string = "Missing PTSA Player JAR file";
            string2 = "XP-ERR-009";
        } else if (jreInfo.missingPatchFiles.isError()) {
            string = "Missing PTSA Player Patch JAR file(s)";
            string2 = "XP-ERR-019";
        }
        this.ptDebug("Error Identified as " + string2 + "; summary = " + string);
        return string2;
    }

    protected String getErrorText(List list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                JreDatum jreDatum = (JreDatum)list.get(i);
                this.addInformation(stringBuilder, jreDatum);
            }
        }
        return stringBuilder.toString();
    }

    protected String getReportText() {
        JreInfo jreInfo = JreInfo.soleInstance();
        StringBuilder stringBuilder = new StringBuilder();
        this.addInformation(stringBuilder, jreInfo.browserName());
        this.addInformation(stringBuilder, jreInfo.jreVersion());
        this.addInformation(stringBuilder, jreInfo.missingPatchFiles());
        this.addInformation(stringBuilder, jreInfo.missingPtaJarFile());
        this.addInformation(stringBuilder, jreInfo.osName());
        this.addInformation(stringBuilder, jreInfo.ptDirectory());
        this.addInformation(stringBuilder, jreInfo.ptPortsAvailable());
        this.addInformation(stringBuilder, jreInfo.ptVersion());
        this.addInformation(stringBuilder, jreInfo.securityAccess());
        return stringBuilder.toString();
    }

    protected boolean initializationError(Throwable throwable) {
        return true;
    }

    protected void ptClearError() {
        this.callJavascript("ptclearError");
    }

    protected void ptDebug(String string) {
        this.callJavascript("ptdebug", string);
    }

    protected void ptLoadingStatus(int n, int n2, int n3) {
        this.callJavascript("ptloadingStatus", n, n2, n3);
    }

    protected void ptSetStatus(String string) {
        this.callJavascript("ptsetStatus", string);
    }

    protected void ptThrowError(String string) {
        this.callJavascript("ptthrowError", string);
    }

    protected void ptUpdateRender() {
        this.callJavascript("ptupdateRender");
    }

    protected boolean stopOnBrowserNameError() {
        return true;
    }

    protected boolean stopOnJarLoadingError(Throwable throwable) {
        return true;
    }

    protected boolean stopOnJreVersionError() {
        return true;
    }

    protected boolean stopOnMissingPatchFilesError(String string) {
        return true;
    }

    protected boolean stopOnNoJarFileError(String string) {
        return true;
    }

    protected boolean stopOnNoPtHomeError() {
        return true;
    }

    protected boolean stopOnNoRawFileError(String string) {
        return true;
    }

    protected boolean stopOnNoSecurityAccessError() {
        return true;
    }

    protected boolean stopOnNoWorkerError() {
        return true;
    }

    protected void stopRunning() {
        this.shouldStop = true;
        if (Thread.currentThread() != this.runThread && this.runThread != null) {
            this.runThread.interrupt();
        }
    }
}

